-- examples of recordsets using plpgsql

SELECT * INTO TEMP TABLE t_temp FROM generate_series(1,10) t(x);

CREATE OR REPLACE FUNCTION get_numbers_ex1(
  OUT mynumber integer
) RETURNS SETOF INTEGER AS
$$
BEGIN
    for mynumber in select generate_series(1,10)
    loop
      return next;
    end loop;
END;
$$
LANGUAGE PLPGSQL;


/*
select * from get_numbers_ex1();
*/

CREATE OR REPLACE FUNCTION get_numbers_ex2(
  OUT mynumber integer
) RETURNS SETOF INTEGER AS
$$
BEGIN
    return query
      select generate_series(1,10);
END;
$$
LANGUAGE PLPGSQL;

/*
select * from get_numbers_ex2();
*/

CREATE OR REPLACE FUNCTION get_numbers_ex3(
--IN  mytable   text,
  IN  mytable   regclass,
  OUT mynumber  integer
) RETURNS SETOF INTEGER AS
$$
DECLARE
  SQL text;
BEGIN
--SQL := 'select * from ' || quote_ident(mytable);
  SQL := 'select * from ' || mytable;
  RETURN QUERY EXECUTE SQL;
END;
$$
LANGUAGE PLPGSQL;

CREATE OR REPLACE FUNCTION get_numbers_ex4()
  RETURNS TABLE (mynumber integer,myrandom float) AS
$$
  select x,random() from t_temp;
$$
LANGUAGE SQL;

/*
select * from get_numbers_ex3('t_temp');
select * from get_numbers_ex4();
*/


CREATE OR REPLACE FUNCTION get_numbers_ex5(
  OUT mynumber integer,
  OUT myrandom float
) RETURNS SETOF RECORD AS
$$
  select x,random() from t_temp;
$$
LANGUAGE SQL;

/*
select * from get_numbers_ex5();
*/
